


//#include "TpmTcpProtocol.h"

//#include "TtvApi.h"
#include "ProvServer.h"

#include <sstream>
#include <string>
#include <vector>
using namespace std;

#pragma comment (lib, "Ws2_32.lib")


TtvServer::TtvServer() {
	mTpmSocket = INVALID_SOCKET;
//	mPlatformSocket = INVALID_SOCKET;
    mRecvBufLen = MAX_BUFFER_LEN;
	mRecvBuf = new char[MAX_BUFFER_LEN];

	memset(g_tpm_in_buffer, 0, MAX_BUFFER_SIZE);
	memset(g_tpm_out_buffer, 0, MAX_BUFFER_SIZE);
	//
	// Setup for use with TPM 2.0 only
	//
	tpm_context_params.version = TBS_CONTEXT_VERSION_TWO;
	tpm_context_params.asUINT32 = 0;
	tpm_context_params.includeTpm12 = 1;
	tpm_context_params.includeTpm20 = 1;
}


TtvServer::~TtvServer() {
	closesocket(mTpmSocket);
//	closesocket(mPlatformSocket);
	delete mRecvBuf;

	//
	// Close TBS Handle
	//
	Tbsip_Context_Close(g_tbs_handle);
}


int TtvServer::readBytes(SOCKET s, char* buffer, int NumBytes) {
    int result;
    int received = 0;

    while(received < NumBytes) {
        result = recv(s, buffer+received, NumBytes-received, 0);
        if(result == -1) {
            printf("Receive error.  Error is 0x%x\n", WSAGetLastError());
            return FALSE;
        }
        else if(result == 0) {
            return FALSE;
        }
        received += result;
    }
    return TRUE;
}


int TtvServer::writeBytes(SOCKET s, char* buffer, int NumBytes) {
    int result;
    int sent = 0;

    while(sent < NumBytes) {
        result = send(s, buffer+sent, NumBytes-sent, 0);
        if(result == -1) {
            if(WSAGetLastError() == 0x2745) {
                printf("Client disconnected\n");
            }
            else {
                printf("Send error.  Error is 0x%x\n", WSAGetLastError());
            }
            return FALSE;
        }
        sent += result;
    }
    return TRUE;
}


int TtvServer::createListenSocket(int portnumber, SOCKET *listensocket) {
    WSADATA wsaData;
    struct addrinfo *result = NULL;
    struct addrinfo hints;
	string servicename;
    int iResult;

    // Initialize Winsock
    iResult = WSAStartup(MAKEWORD(2,2), &wsaData);
    if (iResult != 0) {
        printf("WSAStartup failed with error: %d\n", iResult);
        return 1;
    }

    ZeroMemory(&hints, sizeof(hints));
    hints.ai_family = AF_INET;			// Same as PF_INET
    hints.ai_socktype = SOCK_STREAM;
    hints.ai_protocol = IPPROTO_IP;
    hints.ai_flags = AI_PASSIVE;

    // Resolve the server address and port
	ostringstream convert;
	convert << portnumber;
	servicename = convert.str();// convert portnumber to string
	
printf("DEBUG: servicename = %s\n", servicename.c_str());
    iResult = getaddrinfo(NULL, servicename.c_str(), &hints, &result);
    if ( iResult != 0 ) {
        printf("getaddrinfo failed with error: %d\n", iResult);
        WSACleanup();
        return 1;
    }

    // Create a SOCKET for connecting to server
    *listensocket = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
    if (*listensocket == INVALID_SOCKET) {
        printf("socket failed with error: %ld\n", WSAGetLastError());
        freeaddrinfo(result);
        WSACleanup();
        return 1;
    }

    // Setup the TCP listening socket
    iResult = bind(*listensocket, result->ai_addr, (int)result->ai_addrlen);
    if (iResult == SOCKET_ERROR) {
        printf("bind failed with error: %d\n", WSAGetLastError());
        freeaddrinfo(result);
        closesocket(*listensocket);
        WSACleanup();
        return 1;
    }

    freeaddrinfo(result);

    iResult = listen(*listensocket, SOMAXCONN);
    if (iResult == SOCKET_ERROR) {
        printf("listen failed with error: %d\n", WSAGetLastError());
        closesocket(*listensocket);
        WSACleanup();
        return 1;
    }


}


int TtvServer::processTpmCommand() {

	char ack[4] = {0, 0, 0, 0};		// acknoledge command processing by sending UINT32 of value 0 
    UINT32 length;
	UINT32 respLength;
    UINT32 Command;
    BYTE locality;
    BOOL ok;
    BOOL WasDebugCommand=FALSE;
    //int result;
//    int clientVersion;
	//vector<char> *pktrecv;		// send to TPM
	//vector<char> *pktsend;		// send to socket

	union {
		int int_data;
		char byte_data[4];
	} pktsendsize;
	

	//api.reset();
	while (1) {
		ok = readBytes(mTpmSocket, (char*)&Command, 4);
		// client disconnected (or other error).  We stop processing this client
		// and return to our caller who can stop the server or listen for another
		// connection.
		if (!ok) return TRUE;

		Command = ntohl(Command);
		//printf("DEBUG: TPM Command %d\n", Command);

		// Read locality from packet
		ok = readBytes(mTpmSocket, (char*)&locality, 1);
		if (!ok) return TRUE;
		// Read packet length
		ok = readBytes(mTpmSocket, (char*)&length, 4);
		if (!ok) return TRUE;
		length = ntohl(length);
		// Read data packet
		ok = readBytes(mTpmSocket, mRecvBuf, length);
		if (!ok) return TRUE;

		//
		// Copy nv def command to tpm in buffer
		//
		memcpy_s(g_tpm_in_buffer, MAX_BUFFER_SIZE, mRecvBuf, length);
		/*
		printf("TCP/IP recieve buffer\n");
		for (int i = 0; i < length; i++) {
			printf("Receive Buffer[%d]: 0x%x \n", i, mRecvBuf[i]);
		}
		*/
		printf("TPM2 command\n");
		for (int i = 0; i < length; i++) {
			printf("Command[%d]: 0x%x \n", i, g_tpm_in_buffer[i]);
		}

		//
		// Get command size, pass through functions need non TPM byte order.
		//
		printf("Command size: 0x%x \n", *((UINT32*)&g_tpm_in_buffer[2]));

		UINT32 cmd_size = BSWAP32(*((UINT32*)&g_tpm_in_buffer[2]));
		//printf("cmd_size: 0x%x \n", cmd_size);
		//
		// Use TBS
		//
		UINT32 tbs_out_size = MAX_BUFFER_SIZE;
		tbs_ret_val = Tbsip_Submit_Command(g_tbs_handle, TBS_COMMAND_LOCALITY_ZERO, TBS_COMMAND_PRIORITY_HIGH, g_tpm_in_buffer, cmd_size, g_tpm_out_buffer, &tbs_out_size);
		if (tbs_ret_val != TBS_SUCCESS){
			printf("Tbsip Submit Command returned in failure: 0x%X\n", tbs_ret_val);
			//return false;
		}

		UINT32 resp_size = BSWAP32(((TPM20_Header_Out*)g_tpm_out_buffer)->response_size);
		UINT32 rc_code = BSWAP32(((TPM20_Header_Out*)g_tpm_out_buffer)->response_code);

		printf("TPM2 response size: 0x%x\n\n", resp_size);
		printf("TPM2 response code: 0x%x\n\n", rc_code);

		printf("TBS response size: 0x%x\n", tbs_out_size);
		for (int i = 0; i < tbs_out_size; i++) {
			printf("Response[%d]: 0x%x \n", i, g_tpm_out_buffer[i]);
		}

		if (rc_code != TPM_RC_SUCCESS){
			

		}


		//delete(pktrecv);

		//api.sendTpmGo(locality);
		//pktsend = (vector<char> *)api.recvTpmFifo(locality);

		//pktsendsize.int_data = htonl(pktsend->size());

		//ok = writeBytes(mTpmSocket, pktsendsize.byte_data, 4);
		//ok = writeBytes(mTpmSocket, (char*) pktsend->data(), pktsend->size());

		respLength = htonl(tbs_out_size);
		ok = writeBytes(mTpmSocket, (char*)&respLength, 4);
		ok = writeBytes(mTpmSocket, (char*)g_tpm_out_buffer, tbs_out_size);

		//delete (pktsend);
        //if(!ok) return TRUE;

        ok = writeBytes(mTpmSocket, ack, 4);
       // if(!ok) return TRUE;
       // break;
    }

    return false;
}


int TtvServer::processPlatformCommand() {

	UINT32 Command;
	BOOL ok;
	char ack[4] = { 0, 0, 0, 0 };		// acknoledge command processing by sending UINT32 of value 0 

	while (1) {
		ok = readBytes(mPlatformSocket, (char*)&Command, 4);
		if (!ok) return TRUE;

		Command = ntohl(Command);
		printf("DEBUG: platform command %d\n", Command);
	
		writeBytes(mPlatformSocket, ack, 4);
	}
	return FALSE;
}


DWORD WINAPI TtvServer::startPlatformThread(LPVOID lpParam) {
	TtvServer* self = (TtvServer*)lpParam;
	return self->startPlatformService();
}

DWORD TtvServer::startPlatformService() {

	struct sockaddr_in addr_TtvServer;
	int length = sizeof(addr_TtvServer);

	int iResult;
	int resetsocket = true;
	SOCKET listensocket;

	createListenSocket(DEFAULT_PLATFORM_PORT, &listensocket);

	while (resetsocket) {
		// Accept a socket
		mPlatformSocket = accept(listensocket, (struct sockaddr*) &addr_TtvServer, &length);
		if (mPlatformSocket == INVALID_SOCKET) {
			printf("accept failed with error: %d\n", WSAGetLastError());
			closesocket(listensocket);
			WSACleanup();
			return 1;
		}

		resetsocket = processPlatformCommand();
		closesocket(mPlatformSocket);
	}

	
	// shutdown the connection since we're done
	iResult = shutdown(mPlatformSocket, SD_SEND);
	if (iResult == SOCKET_ERROR) {
		printf("shutdown failed with error: %d\n", WSAGetLastError());
		closesocket(mPlatformSocket);
		WSACleanup();
		return 1;
	}

	// cleanup
	closesocket(mPlatformSocket);
	WSACleanup();
	
}


int TtvServer::startTpmService() {

	struct sockaddr_in addr_TtvServer;
	int length = sizeof(addr_TtvServer);

    int iResult;
	int resetsocket = true;
	SOCKET listensocket;


	//
	// Check for TPM
	//
	tbs_ret_val = Tbsi_Context_Create((PTBS_CONTEXT_PARAMS)&tpm_context_params, &g_tbs_handle);
	if (tbs_ret_val != TBS_SUCCESS){
		//
		// Fail
		//
		printf("Supported TPM not found\n");
		//return TNT_APP_FAIL;
	}


	createListenSocket(DEFAULT_TPM_PORT, &listensocket);

	while (resetsocket) {
	    // Accept a socket
		mTpmSocket = accept(listensocket, (struct sockaddr*) &addr_TtvServer, &length);
		if (mTpmSocket == INVALID_SOCKET) {
			printf("accept failed with error: %d\n", WSAGetLastError());
			closesocket(listensocket);
			WSACleanup();
			return 1;
		}

		resetsocket = processTpmCommand();
		closesocket(mTpmSocket);
	}

	
    // shutdown the connection since we're done
    iResult = shutdown(mTpmSocket, SD_SEND);
    if (iResult == SOCKET_ERROR) {
        printf("shutdown failed with error: %d\n", WSAGetLastError());
        closesocket(mTpmSocket);
        WSACleanup();
        return 1;
    }

    // cleanup
    closesocket(mTpmSocket);
    WSACleanup();
	
	return 0;
}


int TtvServer::start() {

    HANDLE hPlatformServiceThread;
    int    ThreadId;
	
    // Create service thread for platform signals
    hPlatformServiceThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)startPlatformThread, (void*) this, 0, (LPDWORD)&ThreadId);
    if(hPlatformServiceThread == NULL) {
        printf("Thread Creation failed\n");
        return -1;
    }
	
	startTpmService();
	return 0;
}


